package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  Timestamp,
  Arn
}
import scala.jdk.CollectionConverters.*
final case class VirtualNodeRef(
    arn: Arn,
    createdAt: Timestamp,
    lastUpdatedAt: Timestamp,
    meshName: ResourceName,
    meshOwner: AccountId,
    resourceOwner: AccountId,
    version: Long,
    virtualNodeName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeRef = {
    import VirtualNodeRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeRef
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastUpdatedAt(Timestamp.unwrap(lastUpdatedAt): Instant)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .meshOwner(AccountId.unwrap(meshOwner): java.lang.String)
      .resourceOwner(AccountId.unwrap(resourceOwner): java.lang.String)
      .version(version: java.lang.Long)
      .virtualNodeName(ResourceName.unwrap(virtualNodeName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeRef.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeRef.wrap(buildAwsValue())
}
object VirtualNodeRef {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeRef
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeRef =
      zio.aws.appmesh.model.VirtualNodeRef(
        arn,
        createdAt,
        lastUpdatedAt,
        meshName,
        meshOwner,
        resourceOwner,
        version,
        virtualNodeName
      )
    def arn: Arn
    def createdAt: Timestamp
    def lastUpdatedAt: Timestamp
    def meshName: ResourceName
    def meshOwner: AccountId
    def resourceOwner: AccountId
    def version: Long
    def virtualNodeName: ResourceName
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastUpdatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedAt)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, Nothing, AccountId] = ZIO.succeed(meshOwner)
    def getResourceOwner: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(resourceOwner)
    def getVersion: ZIO[Any, Nothing, Long] = ZIO.succeed(version)
    def getVirtualNodeName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNodeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeRef
  ) extends zio.aws.appmesh.model.VirtualNodeRef.ReadOnly {
    override val arn: Arn = zio.aws.appmesh.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.createdAt())
    override val lastUpdatedAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.lastUpdatedAt())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.meshOwner())
    override val resourceOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.resourceOwner())
    override val version: Long = impl.version(): Long
    override val virtualNodeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNodeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeRef
  ): zio.aws.appmesh.model.VirtualNodeRef.ReadOnly = new Wrapper(impl)
}
