package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.appmesh.model.primitives.{
  AccountId,
  Timestamp,
  Arn,
  ServiceName,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class VirtualServiceRef(
    arn: Arn,
    createdAt: Timestamp,
    lastUpdatedAt: Timestamp,
    meshName: ResourceName,
    meshOwner: AccountId,
    resourceOwner: AccountId,
    version: Long,
    virtualServiceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualServiceRef = {
    import VirtualServiceRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualServiceRef
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastUpdatedAt(Timestamp.unwrap(lastUpdatedAt): Instant)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .meshOwner(AccountId.unwrap(meshOwner): java.lang.String)
      .resourceOwner(AccountId.unwrap(resourceOwner): java.lang.String)
      .version(version: java.lang.Long)
      .virtualServiceName(
        ServiceName.unwrap(virtualServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualServiceRef.ReadOnly =
    zio.aws.appmesh.model.VirtualServiceRef.wrap(buildAwsValue())
}
object VirtualServiceRef {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualServiceRef
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualServiceRef =
      zio.aws.appmesh.model.VirtualServiceRef(
        arn,
        createdAt,
        lastUpdatedAt,
        meshName,
        meshOwner,
        resourceOwner,
        version,
        virtualServiceName
      )
    def arn: Arn
    def createdAt: Timestamp
    def lastUpdatedAt: Timestamp
    def meshName: ResourceName
    def meshOwner: AccountId
    def resourceOwner: AccountId
    def version: Long
    def virtualServiceName: ServiceName
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastUpdatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedAt)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, Nothing, AccountId] = ZIO.succeed(meshOwner)
    def getResourceOwner: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(resourceOwner)
    def getVersion: ZIO[Any, Nothing, Long] = ZIO.succeed(version)
    def getVirtualServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(virtualServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceRef
  ) extends zio.aws.appmesh.model.VirtualServiceRef.ReadOnly {
    override val arn: Arn = zio.aws.appmesh.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.createdAt())
    override val lastUpdatedAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.lastUpdatedAt())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.meshOwner())
    override val resourceOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.resourceOwner())
    override val version: Long = impl.version(): Long
    override val virtualServiceName: ServiceName =
      zio.aws.appmesh.model.primitives.ServiceName(impl.virtualServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceRef
  ): zio.aws.appmesh.model.VirtualServiceRef.ReadOnly = new Wrapper(impl)
}
