package zio.aws.appmesh.model
import scala.jdk.CollectionConverters.*
sealed trait VirtualServiceStatusCode {
  def unwrap
      : software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode
}
object VirtualServiceStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode
  ): zio.aws.appmesh.model.VirtualServiceStatusCode = value match {
    case software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appmesh.model.VirtualServiceStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appmesh.model.VirtualServiceStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.ACTIVE
  }
  case object INACTIVE extends zio.aws.appmesh.model.VirtualServiceStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.INACTIVE
  }
  case object DELETED extends zio.aws.appmesh.model.VirtualServiceStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode =
      software.amazon.awssdk.services.appmesh.model.VirtualServiceStatusCode.DELETED
  }
}
