package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  Timestamp,
  Arn
}
import scala.jdk.CollectionConverters.*
final case class GatewayRouteRef(
    arn: Arn,
    createdAt: Timestamp,
    gatewayRouteName: ResourceName,
    lastUpdatedAt: Timestamp,
    meshName: ResourceName,
    meshOwner: AccountId,
    resourceOwner: AccountId,
    version: Long,
    virtualGatewayName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteRef = {
    import GatewayRouteRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteRef
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .gatewayRouteName(ResourceName.unwrap(gatewayRouteName): java.lang.String)
      .lastUpdatedAt(Timestamp.unwrap(lastUpdatedAt): Instant)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .meshOwner(AccountId.unwrap(meshOwner): java.lang.String)
      .resourceOwner(AccountId.unwrap(resourceOwner): java.lang.String)
      .version(version: java.lang.Long)
      .virtualGatewayName(
        ResourceName.unwrap(virtualGatewayName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteRef.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteRef.wrap(buildAwsValue())
}
object GatewayRouteRef {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteRef
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteRef =
      zio.aws.appmesh.model.GatewayRouteRef(
        arn,
        createdAt,
        gatewayRouteName,
        lastUpdatedAt,
        meshName,
        meshOwner,
        resourceOwner,
        version,
        virtualGatewayName
      )
    def arn: Arn
    def createdAt: Timestamp
    def gatewayRouteName: ResourceName
    def lastUpdatedAt: Timestamp
    def meshName: ResourceName
    def meshOwner: AccountId
    def resourceOwner: AccountId
    def version: Long
    def virtualGatewayName: ResourceName
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getGatewayRouteName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(gatewayRouteName)
    def getLastUpdatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedAt)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, Nothing, AccountId] = ZIO.succeed(meshOwner)
    def getResourceOwner: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(resourceOwner)
    def getVersion: ZIO[Any, Nothing, Long] = ZIO.succeed(version)
    def getVirtualGatewayName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualGatewayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteRef
  ) extends zio.aws.appmesh.model.GatewayRouteRef.ReadOnly {
    override val arn: Arn = zio.aws.appmesh.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.createdAt())
    override val gatewayRouteName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.gatewayRouteName())
    override val lastUpdatedAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.lastUpdatedAt())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.meshOwner())
    override val resourceOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.resourceOwner())
    override val version: Long = impl.version(): Long
    override val virtualGatewayName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualGatewayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteRef
  ): zio.aws.appmesh.model.GatewayRouteRef.ReadOnly = new Wrapper(impl)
}
