package zio.aws.appmesh.model
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  ListRoutesLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRoutesRequest(
    limit: Optional[ListRoutesLimit] = Optional.Absent,
    meshName: ResourceName,
    meshOwner: Optional[AccountId] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListRoutesRequest = {
    import ListRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListRoutesLimit.unwrap(value): Integer)
      )(_.limit)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListRoutesRequest.ReadOnly =
    zio.aws.appmesh.model.ListRoutesRequest.wrap(buildAwsValue())
}
object ListRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListRoutesRequest =
      zio.aws.appmesh.model.ListRoutesRequest(
        limit.map(value => value),
        meshName,
        meshOwner.map(value => value),
        nextToken.map(value => value),
        virtualRouterName
      )
    def limit: Optional[ListRoutesLimit]
    def meshName: ResourceName
    def meshOwner: Optional[AccountId]
    def nextToken: Optional[String]
    def virtualRouterName: ResourceName
    def getLimit: ZIO[Any, AwsError, ListRoutesLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
  ) extends zio.aws.appmesh.model.ListRoutesRequest.ReadOnly {
    override val limit: Optional[ListRoutesLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.appmesh.model.primitives.ListRoutesLimit(value))
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListRoutesRequest
  ): zio.aws.appmesh.model.ListRoutesRequest.ReadOnly = new Wrapper(impl)
}
