package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Listener(
    connectionPool: Optional[zio.aws.appmesh.model.VirtualNodeConnectionPool] =
      Optional.Absent,
    healthCheck: Optional[zio.aws.appmesh.model.HealthCheckPolicy] =
      Optional.Absent,
    outlierDetection: Optional[zio.aws.appmesh.model.OutlierDetection] =
      Optional.Absent,
    portMapping: zio.aws.appmesh.model.PortMapping,
    timeout: Optional[zio.aws.appmesh.model.ListenerTimeout] = Optional.Absent,
    tls: Optional[zio.aws.appmesh.model.ListenerTls] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.Listener = {
    import Listener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.Listener
      .builder()
      .optionallyWith(connectionPool.map(value => value.buildAwsValue()))(
        _.connectionPool
      )
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(outlierDetection.map(value => value.buildAwsValue()))(
        _.outlierDetection
      )
      .portMapping(portMapping.buildAwsValue())
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.Listener.ReadOnly =
    zio.aws.appmesh.model.Listener.wrap(buildAwsValue())
}
object Listener {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.Listener] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.Listener =
      zio.aws.appmesh.model.Listener(
        connectionPool.map(value => value.asEditable),
        healthCheck.map(value => value.asEditable),
        outlierDetection.map(value => value.asEditable),
        portMapping.asEditable,
        timeout.map(value => value.asEditable),
        tls.map(value => value.asEditable)
      )
    def connectionPool
        : Optional[zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly]
    def healthCheck: Optional[zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly]
    def outlierDetection
        : Optional[zio.aws.appmesh.model.OutlierDetection.ReadOnly]
    def portMapping: zio.aws.appmesh.model.PortMapping.ReadOnly
    def timeout: Optional[zio.aws.appmesh.model.ListenerTimeout.ReadOnly]
    def tls: Optional[zio.aws.appmesh.model.ListenerTls.ReadOnly]
    def getConnectionPool: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("connectionPool", connectionPool)
    def getHealthCheck
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly] =
      AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getOutlierDetection
        : ZIO[Any, AwsError, zio.aws.appmesh.model.OutlierDetection.ReadOnly] =
      AwsError.unwrapOptionField("outlierDetection", outlierDetection)
    def getPortMapping
        : ZIO[Any, Nothing, zio.aws.appmesh.model.PortMapping.ReadOnly] =
      ZIO.succeed(portMapping)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.appmesh.model.ListenerTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTls: ZIO[Any, AwsError, zio.aws.appmesh.model.ListenerTls.ReadOnly] =
      AwsError.unwrapOptionField("tls", tls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.Listener
  ) extends zio.aws.appmesh.model.Listener.ReadOnly {
    override val connectionPool
        : Optional[zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionPool())
        .map(value =>
          zio.aws.appmesh.model.VirtualNodeConnectionPool.wrap(value)
        )
    override val healthCheck
        : Optional[zio.aws.appmesh.model.HealthCheckPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheck())
        .map(value => zio.aws.appmesh.model.HealthCheckPolicy.wrap(value))
    override val outlierDetection
        : Optional[zio.aws.appmesh.model.OutlierDetection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outlierDetection())
        .map(value => zio.aws.appmesh.model.OutlierDetection.wrap(value))
    override val portMapping: zio.aws.appmesh.model.PortMapping.ReadOnly =
      zio.aws.appmesh.model.PortMapping.wrap(impl.portMapping())
    override val timeout
        : Optional[zio.aws.appmesh.model.ListenerTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeout())
        .map(value => zio.aws.appmesh.model.ListenerTimeout.wrap(value))
    override val tls: Optional[zio.aws.appmesh.model.ListenerTls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tls())
        .map(value => zio.aws.appmesh.model.ListenerTls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.Listener
  ): zio.aws.appmesh.model.Listener.ReadOnly = new Wrapper(impl)
}
