package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListenerTls(
    certificate: zio.aws.appmesh.model.ListenerTlsCertificate,
    mode: zio.aws.appmesh.model.ListenerTlsMode,
    validation: Optional[zio.aws.appmesh.model.ListenerTlsValidationContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTls = {
    import ListenerTls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTls
      .builder()
      .certificate(certificate.buildAwsValue())
      .mode(mode.unwrap)
      .optionallyWith(validation.map(value => value.buildAwsValue()))(
        _.validation
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTls.ReadOnly =
    zio.aws.appmesh.model.ListenerTls.wrap(buildAwsValue())
}
object ListenerTls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTls =
      zio.aws.appmesh.model.ListenerTls(
        certificate.asEditable,
        mode,
        validation.map(value => value.asEditable)
      )
    def certificate: zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly
    def mode: zio.aws.appmesh.model.ListenerTlsMode
    def validation
        : Optional[zio.aws.appmesh.model.ListenerTlsValidationContext.ReadOnly]
    def getCertificate: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly
    ] = ZIO.succeed(certificate)
    def getMode: ZIO[Any, Nothing, zio.aws.appmesh.model.ListenerTlsMode] =
      ZIO.succeed(mode)
    def getValidation: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.ListenerTlsValidationContext.ReadOnly
    ] = AwsError.unwrapOptionField("validation", validation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTls
  ) extends zio.aws.appmesh.model.ListenerTls.ReadOnly {
    override val certificate
        : zio.aws.appmesh.model.ListenerTlsCertificate.ReadOnly =
      zio.aws.appmesh.model.ListenerTlsCertificate.wrap(impl.certificate())
    override val mode: zio.aws.appmesh.model.ListenerTlsMode =
      zio.aws.appmesh.model.ListenerTlsMode.wrap(impl.mode())
    override val validation: Optional[
      zio.aws.appmesh.model.ListenerTlsValidationContext.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validation())
      .map(value =>
        zio.aws.appmesh.model.ListenerTlsValidationContext.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTls
  ): zio.aws.appmesh.model.ListenerTls.ReadOnly = new Wrapper(impl)
}
