package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayAccessLog(
    file: Optional[zio.aws.appmesh.model.VirtualGatewayFileAccessLog] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayAccessLog = {
    import VirtualGatewayAccessLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayAccessLog
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayAccessLog.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayAccessLog.wrap(buildAwsValue())
}
object VirtualGatewayAccessLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayAccessLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayAccessLog =
      zio.aws.appmesh.model
        .VirtualGatewayAccessLog(file.map(value => value.asEditable))
    def file
        : Optional[zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly]
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayAccessLog
  ) extends zio.aws.appmesh.model.VirtualGatewayAccessLog.ReadOnly {
    override val file
        : Optional[zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.file())
        .map(value =>
          zio.aws.appmesh.model.VirtualGatewayFileAccessLog.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayAccessLog
  ): zio.aws.appmesh.model.VirtualGatewayAccessLog.ReadOnly = new Wrapper(impl)
}
