package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.FilePath
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayFileAccessLog(path: FilePath) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog = {
    import VirtualGatewayFileAccessLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
      .builder()
      .path(FilePath.unwrap(path): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayFileAccessLog.wrap(buildAwsValue())
}
object VirtualGatewayFileAccessLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayFileAccessLog =
      zio.aws.appmesh.model.VirtualGatewayFileAccessLog(path)
    def path: FilePath
    def getPath: ZIO[Any, Nothing, FilePath] = ZIO.succeed(path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
  ) extends zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly {
    override val path: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayFileAccessLog
  ): zio.aws.appmesh.model.VirtualGatewayFileAccessLog.ReadOnly = new Wrapper(
    impl
  )
}
