package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.FilePath
import scala.jdk.CollectionConverters.*
final case class VirtualGatewayListenerTlsFileCertificate(
    certificateChain: FilePath,
    privateKey: FilePath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate = {
    import VirtualGatewayListenerTlsFileCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate
      .builder()
      .certificateChain(FilePath.unwrap(certificateChain): java.lang.String)
      .privateKey(FilePath.unwrap(privateKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate
      .wrap(buildAwsValue())
}
object VirtualGatewayListenerTlsFileCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate =
      zio.aws.appmesh.model
        .VirtualGatewayListenerTlsFileCertificate(certificateChain, privateKey)
    def certificateChain: FilePath
    def privateKey: FilePath
    def getCertificateChain: ZIO[Any, Nothing, FilePath] =
      ZIO.succeed(certificateChain)
    def getPrivateKey: ZIO[Any, Nothing, FilePath] = ZIO.succeed(privateKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate
  ) extends zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly {
    override val certificateChain: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.certificateChain())
    override val privateKey: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.privateKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenerTlsFileCertificate
  ): zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly =
    new Wrapper(impl)
}
