package zio.aws.apprunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVpcIngressConnectionResponse(
    vpcIngressConnection: zio.aws.apprunner.model.VpcIngressConnection
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionResponse = {
    import DescribeVpcIngressConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionResponse
      .builder()
      .vpcIngressConnection(vpcIngressConnection.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.DescribeVpcIngressConnectionResponse.ReadOnly =
    zio.aws.apprunner.model.DescribeVpcIngressConnectionResponse
      .wrap(buildAwsValue())
}
object DescribeVpcIngressConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apprunner.model.DescribeVpcIngressConnectionResponse =
      zio.aws.apprunner.model
        .DescribeVpcIngressConnectionResponse(vpcIngressConnection.asEditable)
    def vpcIngressConnection
        : zio.aws.apprunner.model.VpcIngressConnection.ReadOnly
    def getVpcIngressConnection: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.VpcIngressConnection.ReadOnly
    ] = ZIO.succeed(vpcIngressConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionResponse
  ) extends zio.aws.apprunner.model.DescribeVpcIngressConnectionResponse.ReadOnly {
    override val vpcIngressConnection
        : zio.aws.apprunner.model.VpcIngressConnection.ReadOnly =
      zio.aws.apprunner.model.VpcIngressConnection
        .wrap(impl.vpcIngressConnection())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.DescribeVpcIngressConnectionResponse
  ): zio.aws.apprunner.model.DescribeVpcIngressConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
