package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait HealthCheckProtocol {
  def unwrap
      : software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol
}
object HealthCheckProtocol {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol
  ): zio.aws.apprunner.model.HealthCheckProtocol = value match {
    case software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.HealthCheckProtocol {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol =
      software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object TCP extends zio.aws.apprunner.model.HealthCheckProtocol {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol =
      software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol.TCP
  }
  case object HTTP extends zio.aws.apprunner.model.HealthCheckProtocol {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol =
      software.amazon.awssdk.services.apprunner.model.HealthCheckProtocol.HTTP
  }
}
