package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait OperationStatus {
  def unwrap: software.amazon.awssdk.services.apprunner.model.OperationStatus
}
object OperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.OperationStatus
  ): zio.aws.apprunner.model.OperationStatus = value match {
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.ROLLBACK_IN_PROGRESS =>
      val r = ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.ROLLBACK_FAILED =>
      val r = ROLLBACK_FAILED
      r
    case software.amazon.awssdk.services.apprunner.model.OperationStatus.ROLLBACK_SUCCEEDED =>
      val r = ROLLBACK_SUCCEEDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.PENDING
  }
  case object IN_PROGRESS extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.SUCCEEDED
  }
  case object ROLLBACK_IN_PROGRESS
      extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.ROLLBACK_IN_PROGRESS
  }
  case object ROLLBACK_FAILED extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.ROLLBACK_FAILED
  }
  case object ROLLBACK_SUCCEEDED
      extends zio.aws.apprunner.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.OperationStatus =
      software.amazon.awssdk.services.apprunner.model.OperationStatus.ROLLBACK_SUCCEEDED
  }
}
