package zio.aws.apprunner.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.apprunner.model.primitives.{
  Timestamp,
  AppRunnerResourceArn,
  UUID
}
import scala.jdk.CollectionConverters._
final case class OperationSummary(
    id: Optional[UUID] = Optional.Absent,
    `type`: Optional[zio.aws.apprunner.model.OperationType] = Optional.Absent,
    status: Optional[zio.aws.apprunner.model.OperationStatus] = Optional.Absent,
    targetArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    startedAt: Optional[Timestamp] = Optional.Absent,
    endedAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.OperationSummary = {
    import OperationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.OperationSummary
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        targetArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.targetArn)
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(endedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.endedAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.OperationSummary.ReadOnly =
    zio.aws.apprunner.model.OperationSummary.wrap(buildAwsValue())
}
object OperationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.OperationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.OperationSummary =
      zio.aws.apprunner.model.OperationSummary(
        id.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        targetArn.map(value => value),
        startedAt.map(value => value),
        endedAt.map(value => value),
        updatedAt.map(value => value)
      )
    def id: Optional[UUID]
    def `type`: Optional[zio.aws.apprunner.model.OperationType]
    def status: Optional[zio.aws.apprunner.model.OperationStatus]
    def targetArn: Optional[AppRunnerResourceArn]
    def startedAt: Optional[Timestamp]
    def endedAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.apprunner.model.OperationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, zio.aws.apprunner.model.OperationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTargetArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getEndedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endedAt", endedAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.OperationSummary
  ) extends zio.aws.apprunner.model.OperationSummary.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.apprunner.model.primitives.UUID(value))
    override val `type`: Optional[zio.aws.apprunner.model.OperationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.apprunner.model.OperationType.wrap(value))
    override val status: Optional[zio.aws.apprunner.model.OperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.apprunner.model.OperationStatus.wrap(value))
    override val targetArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val startedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val endedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.apprunner.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.OperationSummary
  ): zio.aws.apprunner.model.OperationSummary.ReadOnly = new Wrapper(impl)
}
