package zio.aws.apprunner.model
import scala.jdk.CollectionConverters._
sealed trait SourceCodeVersionType {
  def unwrap
      : software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType
}
object SourceCodeVersionType {
  def wrap(
      value: software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType
  ): zio.aws.apprunner.model.SourceCodeVersionType = value match {
    case software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType.BRANCH =>
      val r = BRANCH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apprunner.model.SourceCodeVersionType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType =
      software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType.UNKNOWN_TO_SDK_VERSION
  }
  case object BRANCH extends zio.aws.apprunner.model.SourceCodeVersionType {
    override def unwrap
        : software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType =
      software.amazon.awssdk.services.apprunner.model.SourceCodeVersionType.BRANCH
  }
}
