package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{TagKey, AppRunnerResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: AppRunnerResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.UntagResourceRequest
      .builder()
      .resourceArn(AppRunnerResourceArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.UntagResourceRequest.ReadOnly =
    zio.aws.apprunner.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.UntagResourceRequest =
      zio.aws.apprunner.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AppRunnerResourceArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.UntagResourceRequest
  ) extends zio.aws.apprunner.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.apprunner.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.UntagResourceRequest
  ): zio.aws.apprunner.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
