package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.AppRunnerResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVpcIngressConnectionRequest(
    vpcIngressConnectionArn: AppRunnerResourceArn,
    ingressVpcConfiguration: zio.aws.apprunner.model.IngressVpcConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.UpdateVpcIngressConnectionRequest = {
    import UpdateVpcIngressConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.UpdateVpcIngressConnectionRequest
      .builder()
      .vpcIngressConnectionArn(
        AppRunnerResourceArn.unwrap(vpcIngressConnectionArn): java.lang.String
      )
      .ingressVpcConfiguration(ingressVpcConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.apprunner.model.UpdateVpcIngressConnectionRequest.ReadOnly =
    zio.aws.apprunner.model.UpdateVpcIngressConnectionRequest
      .wrap(buildAwsValue())
}
object UpdateVpcIngressConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.UpdateVpcIngressConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.UpdateVpcIngressConnectionRequest =
      zio.aws.apprunner.model.UpdateVpcIngressConnectionRequest(
        vpcIngressConnectionArn,
        ingressVpcConfiguration.asEditable
      )
    def vpcIngressConnectionArn: AppRunnerResourceArn
    def ingressVpcConfiguration
        : zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly
    def getVpcIngressConnectionArn: ZIO[Any, Nothing, AppRunnerResourceArn] =
      ZIO.succeed(vpcIngressConnectionArn)
    def getIngressVpcConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly
    ] = ZIO.succeed(ingressVpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateVpcIngressConnectionRequest
  ) extends zio.aws.apprunner.model.UpdateVpcIngressConnectionRequest.ReadOnly {
    override val vpcIngressConnectionArn: AppRunnerResourceArn =
      zio.aws.apprunner.model.primitives
        .AppRunnerResourceArn(impl.vpcIngressConnectionArn())
    override val ingressVpcConfiguration
        : zio.aws.apprunner.model.IngressVpcConfiguration.ReadOnly =
      zio.aws.apprunner.model.IngressVpcConfiguration
        .wrap(impl.ingressVpcConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.UpdateVpcIngressConnectionRequest
  ): zio.aws.apprunner.model.UpdateVpcIngressConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
