package zio.aws.apprunner.model
import zio.aws.apprunner.model.primitives.{DomainName, AppRunnerResourceArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcDNSTarget(
    vpcIngressConnectionArn: Optional[AppRunnerResourceArn] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apprunner.model.VpcDNSTarget = {
    import VpcDNSTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apprunner.model.VpcDNSTarget
      .builder()
      .optionallyWith(
        vpcIngressConnectionArn.map(value =>
          AppRunnerResourceArn.unwrap(value): java.lang.String
        )
      )(_.vpcIngressConnectionArn)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .build()
  }
  def asReadOnly: zio.aws.apprunner.model.VpcDNSTarget.ReadOnly =
    zio.aws.apprunner.model.VpcDNSTarget.wrap(buildAwsValue())
}
object VpcDNSTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apprunner.model.VpcDNSTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apprunner.model.VpcDNSTarget =
      zio.aws.apprunner.model.VpcDNSTarget(
        vpcIngressConnectionArn.map(value => value),
        vpcId.map(value => value),
        domainName.map(value => value)
      )
    def vpcIngressConnectionArn: Optional[AppRunnerResourceArn]
    def vpcId: Optional[String]
    def domainName: Optional[DomainName]
    def getVpcIngressConnectionArn: ZIO[Any, AwsError, AppRunnerResourceArn] =
      AwsError.unwrapOptionField(
        "vpcIngressConnectionArn",
        vpcIngressConnectionArn
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apprunner.model.VpcDNSTarget
  ) extends zio.aws.apprunner.model.VpcDNSTarget.ReadOnly {
    override val vpcIngressConnectionArn: Optional[AppRunnerResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcIngressConnectionArn())
        .map(value =>
          zio.aws.apprunner.model.primitives.AppRunnerResourceArn(value)
        )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.apprunner.model.primitives.DomainName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apprunner.model.VpcDNSTarget
  ): zio.aws.apprunner.model.VpcDNSTarget.ReadOnly = new Wrapper(impl)
}
