package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{Timestamp, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AppBlock(
    name: String,
    arn: Arn,
    description: Optional[String] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    sourceS3Location: Optional[zio.aws.appstream.model.S3Location] =
      Optional.Absent,
    setupScriptDetails: zio.aws.appstream.model.ScriptDetails,
    createdTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AppBlock = {
    import AppBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AppBlock
      .builder()
      .name(name: java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(sourceS3Location.map(value => value.buildAwsValue()))(
        _.sourceS3Location
      )
      .setupScriptDetails(setupScriptDetails.buildAwsValue())
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.AppBlock.ReadOnly =
    zio.aws.appstream.model.AppBlock.wrap(buildAwsValue())
}
object AppBlock {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AppBlock
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.AppBlock =
      zio.aws.appstream.model.AppBlock(
        name,
        arn,
        description.map(value => value),
        displayName.map(value => value),
        sourceS3Location.map(value => value.asEditable),
        setupScriptDetails.asEditable,
        createdTime.map(value => value)
      )
    def name: String
    def arn: Arn
    def description: Optional[String]
    def displayName: Optional[String]
    def sourceS3Location: Optional[zio.aws.appstream.model.S3Location.ReadOnly]
    def setupScriptDetails: zio.aws.appstream.model.ScriptDetails.ReadOnly
    def createdTime: Optional[Timestamp]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getSourceS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Location", sourceS3Location)
    def getSetupScriptDetails
        : ZIO[Any, Nothing, zio.aws.appstream.model.ScriptDetails.ReadOnly] =
      ZIO.succeed(setupScriptDetails)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AppBlock
  ) extends zio.aws.appstream.model.AppBlock.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: Arn = zio.aws.appstream.model.primitives.Arn(impl.arn())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val sourceS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceS3Location())
        .map(value => zio.aws.appstream.model.S3Location.wrap(value))
    override val setupScriptDetails
        : zio.aws.appstream.model.ScriptDetails.ReadOnly =
      zio.aws.appstream.model.ScriptDetails.wrap(impl.setupScriptDetails())
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AppBlock
  ): zio.aws.appstream.model.AppBlock.ReadOnly = new Wrapper(impl)
}
