package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{Timestamp, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Application(
    name: Optional[String] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    iconURL: Optional[String] = Optional.Absent,
    launchPath: Optional[String] = Optional.Absent,
    launchParameters: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    metadata: Optional[Map[String, String]] = Optional.Absent,
    workingDirectory: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    appBlockArn: Optional[Arn] = Optional.Absent,
    iconS3Location: Optional[zio.aws.appstream.model.S3Location] =
      Optional.Absent,
    platforms: Optional[Iterable[zio.aws.appstream.model.PlatformType]] =
      Optional.Absent,
    instanceFamilies: Optional[Iterable[String]] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.Application = {
    import Application.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Application
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(iconURL.map(value => value: java.lang.String))(_.iconURL)
      .optionallyWith(launchPath.map(value => value: java.lang.String))(
        _.launchPath
      )
      .optionallyWith(launchParameters.map(value => value: java.lang.String))(
        _.launchParameters
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(workingDirectory.map(value => value: java.lang.String))(
        _.workingDirectory
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        appBlockArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.appBlockArn)
      .optionallyWith(iconS3Location.map(value => value.buildAwsValue()))(
        _.iconS3Location
      )
      .optionallyWith(
        platforms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformsWithStrings)
      .optionallyWith(
        instanceFamilies.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceFamilies)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Application.ReadOnly =
    zio.aws.appstream.model.Application.wrap(buildAwsValue())
}
object Application {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.Application
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Application =
      zio.aws.appstream.model.Application(
        name.map(value => value),
        displayName.map(value => value),
        iconURL.map(value => value),
        launchPath.map(value => value),
        launchParameters.map(value => value),
        enabled.map(value => value),
        metadata.map(value => value),
        workingDirectory.map(value => value),
        description.map(value => value),
        arn.map(value => value),
        appBlockArn.map(value => value),
        iconS3Location.map(value => value.asEditable),
        platforms.map(value => value),
        instanceFamilies.map(value => value),
        createdTime.map(value => value)
      )
    def name: Optional[String]
    def displayName: Optional[String]
    def iconURL: Optional[String]
    def launchPath: Optional[String]
    def launchParameters: Optional[String]
    def enabled: Optional[Boolean]
    def metadata: Optional[Map[String, String]]
    def workingDirectory: Optional[String]
    def description: Optional[String]
    def arn: Optional[Arn]
    def appBlockArn: Optional[Arn]
    def iconS3Location: Optional[zio.aws.appstream.model.S3Location.ReadOnly]
    def platforms: Optional[List[zio.aws.appstream.model.PlatformType]]
    def instanceFamilies: Optional[List[String]]
    def createdTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getIconURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iconURL", iconURL)
    def getLaunchPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchPath", launchPath)
    def getLaunchParameters: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchParameters", launchParameters)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getMetadata: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getWorkingDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getAppBlockArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("appBlockArn", appBlockArn)
    def getIconS3Location
        : ZIO[Any, AwsError, zio.aws.appstream.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("iconS3Location", iconS3Location)
    def getPlatforms
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.PlatformType]] =
      AwsError.unwrapOptionField("platforms", platforms)
    def getInstanceFamilies: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceFamilies", instanceFamilies)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Application
  ) extends zio.aws.appstream.model.Application.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val iconURL: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iconURL())
      .map(value => value: String)
    override val launchPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchPath())
      .map(value => value: String)
    override val launchParameters: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchParameters())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val metadata: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val workingDirectory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workingDirectory())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val appBlockArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.appBlockArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val iconS3Location
        : Optional[zio.aws.appstream.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iconS3Location())
        .map(value => zio.aws.appstream.model.S3Location.wrap(value))
    override val platforms
        : Optional[List[zio.aws.appstream.model.PlatformType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.PlatformType.wrap(item)
          }.toList
        )
    override val instanceFamilies: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceFamilies())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Application
  ): zio.aws.appstream.model.Application.ReadOnly = new Wrapper(impl)
}
