package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchAssociateUserStackRequest(
    userStackAssociations: Iterable[
      zio.aws.appstream.model.UserStackAssociation
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest = {
    import BatchAssociateUserStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest
      .builder()
      .userStackAssociations(userStackAssociations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.BatchAssociateUserStackRequest.ReadOnly =
    zio.aws.appstream.model.BatchAssociateUserStackRequest.wrap(buildAwsValue())
}
object BatchAssociateUserStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.BatchAssociateUserStackRequest =
      zio.aws.appstream.model
        .BatchAssociateUserStackRequest(userStackAssociations.map { item =>
          item.asEditable
        })
    def userStackAssociations
        : List[zio.aws.appstream.model.UserStackAssociation.ReadOnly]
    def getUserStackAssociations: ZIO[Any, Nothing, List[
      zio.aws.appstream.model.UserStackAssociation.ReadOnly
    ]] = ZIO.succeed(userStackAssociations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest
  ) extends zio.aws.appstream.model.BatchAssociateUserStackRequest.ReadOnly {
    override val userStackAssociations
        : List[zio.aws.appstream.model.UserStackAssociation.ReadOnly] = impl
      .userStackAssociations()
      .asScala
      .map { item =>
        zio.aws.appstream.model.UserStackAssociation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest
  ): zio.aws.appstream.model.BatchAssociateUserStackRequest.ReadOnly =
    new Wrapper(impl)
}
