package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchAssociateUserStackResponse(
    errors: Optional[
      Iterable[zio.aws.appstream.model.UserStackAssociationError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackResponse = {
    import BatchAssociateUserStackResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly =
    zio.aws.appstream.model.BatchAssociateUserStackResponse
      .wrap(buildAwsValue())
}
object BatchAssociateUserStackResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.BatchAssociateUserStackResponse =
      zio.aws.appstream.model.BatchAssociateUserStackResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[
      List[zio.aws.appstream.model.UserStackAssociationError.ReadOnly]
    ]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserStackAssociationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackResponse
  ) extends zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.appstream.model.UserStackAssociationError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.UserStackAssociationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackResponse
  ): zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly =
    new Wrapper(impl)
}
