package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ComputeCapacity(desiredInstances: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ComputeCapacity = {
    import ComputeCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ComputeCapacity
      .builder()
      .desiredInstances(desiredInstances: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ComputeCapacity.ReadOnly =
    zio.aws.appstream.model.ComputeCapacity.wrap(buildAwsValue())
}
object ComputeCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ComputeCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ComputeCapacity =
      zio.aws.appstream.model.ComputeCapacity(desiredInstances)
    def desiredInstances: Integer
    def getDesiredInstances: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(desiredInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacity
  ) extends zio.aws.appstream.model.ComputeCapacity.ReadOnly {
    override val desiredInstances: Integer = impl.desiredInstances(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacity
  ): zio.aws.appstream.model.ComputeCapacity.ReadOnly = new Wrapper(impl)
}
