package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.Timestamp
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateStreamingUrlResponse(
    streamingURL: Optional[String] = Optional.Absent,
    expires: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse = {
    import CreateStreamingUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
      .builder()
      .optionallyWith(streamingURL.map(value => value: java.lang.String))(
        _.streamingURL
      )
      .optionallyWith(expires.map(value => Timestamp.unwrap(value): Instant))(
        _.expires
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly =
    zio.aws.appstream.model.CreateStreamingUrlResponse.wrap(buildAwsValue())
}
object CreateStreamingUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateStreamingUrlResponse =
      zio.aws.appstream.model.CreateStreamingUrlResponse(
        streamingURL.map(value => value),
        expires.map(value => value)
      )
    def streamingURL: Optional[String]
    def expires: Optional[Timestamp]
    def getStreamingURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamingURL", streamingURL)
    def getExpires: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expires", expires)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
  ) extends zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly {
    override val streamingURL: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.streamingURL())
      .map(value => value: String)
    override val expires: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse
  ): zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
