package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  DisplayName,
  TagValue,
  Description,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateUpdatedImageRequest(
    existingImageName: Name,
    newImageName: Name,
    newImageDescription: Optional[Description] = Optional.Absent,
    newImageDisplayName: Optional[DisplayName] = Optional.Absent,
    newImageTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest = {
    import CreateUpdatedImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest
      .builder()
      .existingImageName(Name.unwrap(existingImageName): java.lang.String)
      .newImageName(Name.unwrap(newImageName): java.lang.String)
      .optionallyWith(
        newImageDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.newImageDescription)
      .optionallyWith(
        newImageDisplayName.map(value =>
          DisplayName.unwrap(value): java.lang.String
        )
      )(_.newImageDisplayName)
      .optionallyWith(
        newImageTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.newImageTags)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.CreateUpdatedImageRequest.ReadOnly =
    zio.aws.appstream.model.CreateUpdatedImageRequest.wrap(buildAwsValue())
}
object CreateUpdatedImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.CreateUpdatedImageRequest =
      zio.aws.appstream.model.CreateUpdatedImageRequest(
        existingImageName,
        newImageName,
        newImageDescription.map(value => value),
        newImageDisplayName.map(value => value),
        newImageTags.map(value => value),
        dryRun.map(value => value)
      )
    def existingImageName: Name
    def newImageName: Name
    def newImageDescription: Optional[Description]
    def newImageDisplayName: Optional[DisplayName]
    def newImageTags: Optional[Map[TagKey, TagValue]]
    def dryRun: Optional[Boolean]
    def getExistingImageName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(existingImageName)
    def getNewImageName: ZIO[Any, Nothing, Name] = ZIO.succeed(newImageName)
    def getNewImageDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("newImageDescription", newImageDescription)
    def getNewImageDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("newImageDisplayName", newImageDisplayName)
    def getNewImageTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("newImageTags", newImageTags)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest
  ) extends zio.aws.appstream.model.CreateUpdatedImageRequest.ReadOnly {
    override val existingImageName: Name =
      zio.aws.appstream.model.primitives.Name(impl.existingImageName())
    override val newImageName: Name =
      zio.aws.appstream.model.primitives.Name(impl.newImageName())
    override val newImageDescription: Optional[Description] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newImageDescription())
        .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val newImageDisplayName: Optional[DisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newImageDisplayName())
        .map(value => zio.aws.appstream.model.primitives.DisplayName(value))
    override val newImageTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newImageTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appstream.model.primitives.TagKey(
                key
              ) -> zio.aws.appstream.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest
  ): zio.aws.appstream.model.CreateUpdatedImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
