package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Username
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(
    userName: Username,
    authenticationType: zio.aws.appstream.model.AuthenticationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteUserRequest
      .builder()
      .userName(Username.unwrap(userName): java.lang.String)
      .authenticationType(authenticationType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteUserRequest.ReadOnly =
    zio.aws.appstream.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteUserRequest =
      zio.aws.appstream.model.DeleteUserRequest(userName, authenticationType)
    def userName: Username
    def authenticationType: zio.aws.appstream.model.AuthenticationType
    def getUserName: ZIO[Any, Nothing, Username] = ZIO.succeed(userName)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteUserRequest
  ) extends zio.aws.appstream.model.DeleteUserRequest.ReadOnly {
    override val userName: Username =
      zio.aws.appstream.model.primitives.Username(impl.userName())
    override val authenticationType
        : zio.aws.appstream.model.AuthenticationType =
      zio.aws.appstream.model.AuthenticationType.wrap(impl.authenticationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteUserRequest
  ): zio.aws.appstream.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
