package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, DirectoryName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDirectoryConfigsRequest(
    directoryNames: Optional[Iterable[DirectoryName]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest = {
    import DescribeDirectoryConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
      .builder()
      .optionallyWith(
        directoryNames.map(value =>
          value.map { item =>
            DirectoryName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.directoryNames)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeDirectoryConfigsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeDirectoryConfigsRequest
      .wrap(buildAwsValue())
}
object DescribeDirectoryConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeDirectoryConfigsRequest =
      zio.aws.appstream.model.DescribeDirectoryConfigsRequest(
        directoryNames.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def directoryNames: Optional[List[DirectoryName]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getDirectoryNames: ZIO[Any, AwsError, List[DirectoryName]] =
      AwsError.unwrapOptionField("directoryNames", directoryNames)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
  ) extends zio.aws.appstream.model.DescribeDirectoryConfigsRequest.ReadOnly {
    override val directoryNames: Optional[List[DirectoryName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.DirectoryName(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest
  ): zio.aws.appstream.model.DescribeDirectoryConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
