package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDirectoryConfigsResponse(
    directoryConfigs: Optional[
      Iterable[zio.aws.appstream.model.DirectoryConfig]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse = {
    import DescribeDirectoryConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse
      .builder()
      .optionallyWith(
        directoryConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.directoryConfigs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeDirectoryConfigsResponse
      .wrap(buildAwsValue())
}
object DescribeDirectoryConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeDirectoryConfigsResponse =
      zio.aws.appstream.model.DescribeDirectoryConfigsResponse(
        directoryConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def directoryConfigs
        : Optional[List[zio.aws.appstream.model.DirectoryConfig.ReadOnly]]
    def nextToken: Optional[String]
    def getDirectoryConfigs: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.DirectoryConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("directoryConfigs", directoryConfigs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse
  ) extends zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly {
    override val directoryConfigs
        : Optional[List[zio.aws.appstream.model.DirectoryConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.DirectoryConfig.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse
  ): zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
