package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Integer, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEntitlementsRequest(
    name: Optional[Name] = Optional.Absent,
    stackName: Name,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest = {
    import DescribeEntitlementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .stackName(Name.unwrap(stackName): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeEntitlementsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeEntitlementsRequest.wrap(buildAwsValue())
}
object DescribeEntitlementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeEntitlementsRequest =
      zio.aws.appstream.model.DescribeEntitlementsRequest(
        name.map(value => value),
        stackName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: Optional[Name]
    def stackName: Name
    def nextToken: Optional[String]
    def maxResults: Optional[Integer]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest
  ) extends zio.aws.appstream.model.DescribeEntitlementsRequest.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appstream.model.primitives.Name(value))
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest
  ): zio.aws.appstream.model.DescribeEntitlementsRequest.ReadOnly = new Wrapper(
    impl
  )
}
