package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImageBuildersResponse(
    imageBuilders: Optional[Iterable[zio.aws.appstream.model.ImageBuilder]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse = {
    import DescribeImageBuildersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
      .builder()
      .optionallyWith(
        imageBuilders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageBuilders)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly =
    zio.aws.appstream.model.DescribeImageBuildersResponse.wrap(buildAwsValue())
}
object DescribeImageBuildersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeImageBuildersResponse =
      zio.aws.appstream.model.DescribeImageBuildersResponse(
        imageBuilders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def imageBuilders
        : Optional[List[zio.aws.appstream.model.ImageBuilder.ReadOnly]]
    def nextToken: Optional[String]
    def getImageBuilders: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ImageBuilder.ReadOnly
    ]] = AwsError.unwrapOptionField("imageBuilders", imageBuilders)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
  ) extends zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly {
    override val imageBuilders
        : Optional[List[zio.aws.appstream.model.ImageBuilder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuilders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.ImageBuilder.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse
  ): zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly =
    new Wrapper(impl)
}
