package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Arn, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateApplicationFleetRequest(
    fleetName: Name,
    applicationArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest = {
    import DisassociateApplicationFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest
      .builder()
      .fleetName(Name.unwrap(fleetName): java.lang.String)
      .applicationArn(Arn.unwrap(applicationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DisassociateApplicationFleetRequest.ReadOnly =
    zio.aws.appstream.model.DisassociateApplicationFleetRequest
      .wrap(buildAwsValue())
}
object DisassociateApplicationFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DisassociateApplicationFleetRequest =
      zio.aws.appstream.model
        .DisassociateApplicationFleetRequest(fleetName, applicationArn)
    def fleetName: Name
    def applicationArn: Arn
    def getFleetName: ZIO[Any, Nothing, Name] = ZIO.succeed(fleetName)
    def getApplicationArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(applicationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest
  ) extends zio.aws.appstream.model.DisassociateApplicationFleetRequest.ReadOnly {
    override val fleetName: Name =
      zio.aws.appstream.model.primitives.Name(impl.fleetName())
    override val applicationArn: Arn =
      zio.aws.appstream.model.primitives.Arn(impl.applicationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest
  ): zio.aws.appstream.model.DisassociateApplicationFleetRequest.ReadOnly =
    new Wrapper(impl)
}
