package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  OrganizationalUnitDistinguishedName,
  DirectoryName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DomainJoinInfo(
    directoryName: Optional[DirectoryName] = Optional.Absent,
    organizationalUnitDistinguishedName: Optional[
      OrganizationalUnitDistinguishedName
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DomainJoinInfo = {
    import DomainJoinInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DomainJoinInfo
      .builder()
      .optionallyWith(
        directoryName.map(value =>
          DirectoryName.unwrap(value): java.lang.String
        )
      )(_.directoryName)
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          OrganizationalUnitDistinguishedName.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DomainJoinInfo.ReadOnly =
    zio.aws.appstream.model.DomainJoinInfo.wrap(buildAwsValue())
}
object DomainJoinInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DomainJoinInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DomainJoinInfo =
      zio.aws.appstream.model.DomainJoinInfo(
        directoryName.map(value => value),
        organizationalUnitDistinguishedName.map(value => value)
      )
    def directoryName: Optional[DirectoryName]
    def organizationalUnitDistinguishedName
        : Optional[OrganizationalUnitDistinguishedName]
    def getDirectoryName: ZIO[Any, AwsError, DirectoryName] =
      AwsError.unwrapOptionField("directoryName", directoryName)
    def getOrganizationalUnitDistinguishedName
        : ZIO[Any, AwsError, OrganizationalUnitDistinguishedName] =
      AwsError.unwrapOptionField(
        "organizationalUnitDistinguishedName",
        organizationalUnitDistinguishedName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DomainJoinInfo
  ) extends zio.aws.appstream.model.DomainJoinInfo.ReadOnly {
    override val directoryName: Optional[DirectoryName] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryName())
      .map(value => zio.aws.appstream.model.primitives.DirectoryName(value))
    override val organizationalUnitDistinguishedName
        : Optional[OrganizationalUnitDistinguishedName] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationalUnitDistinguishedName())
      .map(value =>
        zio.aws.appstream.model.primitives
          .OrganizationalUnitDistinguishedName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DomainJoinInfo
  ): zio.aws.appstream.model.DomainJoinInfo.ReadOnly = new Wrapper(impl)
}
