package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait FleetErrorCode {
  def unwrap: software.amazon.awssdk.services.appstream.model.FleetErrorCode
}
object FleetErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.FleetErrorCode
  ): zio.aws.appstream.model.FleetErrorCode = value match {
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION =>
      val r = IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION =>
      val r = IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION =>
      val r = IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.NETWORK_INTERFACE_LIMIT_EXCEEDED =>
      val r = NETWORK_INTERFACE_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.INTERNAL_SERVICE_ERROR =>
      val r = INTERNAL_SERVICE_ERROR
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_IS_MISSING =>
      val r = IAM_SERVICE_ROLE_IS_MISSING
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.MACHINE_ROLE_IS_MISSING =>
      val r = MACHINE_ROLE_IS_MISSING
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.STS_DISABLED_IN_REGION =>
      val r = STS_DISABLED_IN_REGION
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES =>
      val r = SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION =>
      val r = IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.SUBNET_NOT_FOUND =>
      val r = SUBNET_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IMAGE_NOT_FOUND =>
      val r = IMAGE_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.INVALID_SUBNET_CONFIGURATION =>
      val r = INVALID_SUBNET_CONFIGURATION
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.SECURITY_GROUPS_NOT_FOUND =>
      val r = SECURITY_GROUPS_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IGW_NOT_ATTACHED =>
      val r = IGW_NOT_ATTACHED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION =>
      val r = IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.FLEET_STOPPED =>
      val r = FLEET_STOPPED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.FLEET_INSTANCE_PROVISIONING_FAILURE =>
      val r = FLEET_INSTANCE_PROVISIONING_FAILURE
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_FILE_NOT_FOUND =>
      val r = DOMAIN_JOIN_ERROR_FILE_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_ACCESS_DENIED =>
      val r = DOMAIN_JOIN_ERROR_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_LOGON_FAILURE =>
      val r = DOMAIN_JOIN_ERROR_LOGON_FAILURE
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_INVALID_PARAMETER =>
      val r = DOMAIN_JOIN_ERROR_INVALID_PARAMETER
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_MORE_DATA =>
      val r = DOMAIN_JOIN_ERROR_MORE_DATA
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN =>
      val r = DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_NOT_SUPPORTED =>
      val r = DOMAIN_JOIN_ERROR_NOT_SUPPORTED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME =>
      val r = DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED =>
      val r = DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED =>
      val r = DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_NERR_PASSWORD_EXPIRED =>
      val r = DOMAIN_JOIN_NERR_PASSWORD_EXPIRED
      r
    case software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_INTERNAL_SERVICE_ERROR =>
      val r = DOMAIN_JOIN_INTERNAL_SERVICE_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION
  }
  case object IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION
  }
  case object IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION
  }
  case object NETWORK_INTERFACE_LIMIT_EXCEEDED
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.NETWORK_INTERFACE_LIMIT_EXCEEDED
  }
  case object INTERNAL_SERVICE_ERROR
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.INTERNAL_SERVICE_ERROR
  }
  case object IAM_SERVICE_ROLE_IS_MISSING
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_IS_MISSING
  }
  case object MACHINE_ROLE_IS_MISSING
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.MACHINE_ROLE_IS_MISSING
  }
  case object STS_DISABLED_IN_REGION
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.STS_DISABLED_IN_REGION
  }
  case object SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES
  }
  case object IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION
  }
  case object SUBNET_NOT_FOUND extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.SUBNET_NOT_FOUND
  }
  case object IMAGE_NOT_FOUND extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IMAGE_NOT_FOUND
  }
  case object INVALID_SUBNET_CONFIGURATION
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.INVALID_SUBNET_CONFIGURATION
  }
  case object SECURITY_GROUPS_NOT_FOUND
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.SECURITY_GROUPS_NOT_FOUND
  }
  case object IGW_NOT_ATTACHED extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IGW_NOT_ATTACHED
  }
  case object IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION
  }
  case object FLEET_STOPPED extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.FLEET_STOPPED
  }
  case object FLEET_INSTANCE_PROVISIONING_FAILURE
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.FLEET_INSTANCE_PROVISIONING_FAILURE
  }
  case object DOMAIN_JOIN_ERROR_FILE_NOT_FOUND
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_FILE_NOT_FOUND
  }
  case object DOMAIN_JOIN_ERROR_ACCESS_DENIED
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_ACCESS_DENIED
  }
  case object DOMAIN_JOIN_ERROR_LOGON_FAILURE
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_LOGON_FAILURE
  }
  case object DOMAIN_JOIN_ERROR_INVALID_PARAMETER
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_INVALID_PARAMETER
  }
  case object DOMAIN_JOIN_ERROR_MORE_DATA
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_MORE_DATA
  }
  case object DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN
  }
  case object DOMAIN_JOIN_ERROR_NOT_SUPPORTED
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_NOT_SUPPORTED
  }
  case object DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME
  }
  case object DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED
  }
  case object DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED
  }
  case object DOMAIN_JOIN_NERR_PASSWORD_EXPIRED
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_NERR_PASSWORD_EXPIRED
  }
  case object DOMAIN_JOIN_INTERNAL_SERVICE_ERROR
      extends zio.aws.appstream.model.FleetErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetErrorCode =
      software.amazon.awssdk.services.appstream.model.FleetErrorCode.DOMAIN_JOIN_INTERNAL_SERVICE_ERROR
  }
}
