package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait FleetState {
  def unwrap: software.amazon.awssdk.services.appstream.model.FleetState
}
object FleetState {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.FleetState
  ): zio.aws.appstream.model.FleetState = value match {
    case software.amazon.awssdk.services.appstream.model.FleetState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.FleetState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.appstream.model.FleetState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.appstream.model.FleetState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.appstream.model.FleetState.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.FleetState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetState =
      software.amazon.awssdk.services.appstream.model.FleetState.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTING extends zio.aws.appstream.model.FleetState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetState =
      software.amazon.awssdk.services.appstream.model.FleetState.STARTING
  }
  case object RUNNING extends zio.aws.appstream.model.FleetState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetState =
      software.amazon.awssdk.services.appstream.model.FleetState.RUNNING
  }
  case object STOPPING extends zio.aws.appstream.model.FleetState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetState =
      software.amazon.awssdk.services.appstream.model.FleetState.STOPPING
  }
  case object STOPPED extends zio.aws.appstream.model.FleetState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetState =
      software.amazon.awssdk.services.appstream.model.FleetState.STOPPED
  }
}
