package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.BooleanObject
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImagePermissions(
    allowFleet: Optional[BooleanObject] = Optional.Absent,
    allowImageBuilder: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ImagePermissions = {
    import ImagePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ImagePermissions
      .builder()
      .optionallyWith(allowFleet.map(value => value: java.lang.Boolean))(
        _.allowFleet
      )
      .optionallyWith(allowImageBuilder.map(value => value: java.lang.Boolean))(
        _.allowImageBuilder
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ImagePermissions.ReadOnly =
    zio.aws.appstream.model.ImagePermissions.wrap(buildAwsValue())
}
object ImagePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ImagePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ImagePermissions =
      zio.aws.appstream.model.ImagePermissions(
        allowFleet.map(value => value),
        allowImageBuilder.map(value => value)
      )
    def allowFleet: Optional[BooleanObject]
    def allowImageBuilder: Optional[BooleanObject]
    def getAllowFleet: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("allowFleet", allowFleet)
    def getAllowImageBuilder: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("allowImageBuilder", allowImageBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ImagePermissions
  ) extends zio.aws.appstream.model.ImagePermissions.ReadOnly {
    override val allowFleet: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.allowFleet())
      .map(value => value: BooleanObject)
    override val allowImageBuilder: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowImageBuilder())
        .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ImagePermissions
  ): zio.aws.appstream.model.ImagePermissions.ReadOnly = new Wrapper(impl)
}
