package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageStateChangeReason(
    code: Optional[zio.aws.appstream.model.ImageStateChangeReasonCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ImageStateChangeReason = {
    import ImageStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ImageStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ImageStateChangeReason.ReadOnly =
    zio.aws.appstream.model.ImageStateChangeReason.wrap(buildAwsValue())
}
object ImageStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ImageStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ImageStateChangeReason =
      zio.aws.appstream.model.ImageStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.appstream.model.ImageStateChangeReasonCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ImageStateChangeReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ImageStateChangeReason
  ) extends zio.aws.appstream.model.ImageStateChangeReason.ReadOnly {
    override val code
        : Optional[zio.aws.appstream.model.ImageStateChangeReasonCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.appstream.model.ImageStateChangeReasonCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ImageStateChangeReason
  ): zio.aws.appstream.model.ImageStateChangeReason.ReadOnly = new Wrapper(impl)
}
