package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait MessageAction {
  def unwrap: software.amazon.awssdk.services.appstream.model.MessageAction
}
object MessageAction {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.MessageAction
  ): zio.aws.appstream.model.MessageAction = value match {
    case software.amazon.awssdk.services.appstream.model.MessageAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.MessageAction.SUPPRESS =>
      val r = SUPPRESS
      r
    case software.amazon.awssdk.services.appstream.model.MessageAction.RESEND =>
      val r = RESEND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.MessageAction {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.MessageAction =
      software.amazon.awssdk.services.appstream.model.MessageAction.UNKNOWN_TO_SDK_VERSION
  }
  case object SUPPRESS extends zio.aws.appstream.model.MessageAction {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.MessageAction =
      software.amazon.awssdk.services.appstream.model.MessageAction.SUPPRESS
  }
  case object RESEND extends zio.aws.appstream.model.MessageAction {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.MessageAction =
      software.amazon.awssdk.services.appstream.model.MessageAction.RESEND
  }
}
