package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.AwsAccountId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SharedImagePermissions(
    sharedAccountId: AwsAccountId,
    imagePermissions: zio.aws.appstream.model.ImagePermissions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.SharedImagePermissions = {
    import SharedImagePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.SharedImagePermissions
      .builder()
      .sharedAccountId(AwsAccountId.unwrap(sharedAccountId): java.lang.String)
      .imagePermissions(imagePermissions.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.SharedImagePermissions.ReadOnly =
    zio.aws.appstream.model.SharedImagePermissions.wrap(buildAwsValue())
}
object SharedImagePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.SharedImagePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.SharedImagePermissions =
      zio.aws.appstream.model
        .SharedImagePermissions(sharedAccountId, imagePermissions.asEditable)
    def sharedAccountId: AwsAccountId
    def imagePermissions: zio.aws.appstream.model.ImagePermissions.ReadOnly
    def getSharedAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(sharedAccountId)
    def getImagePermissions
        : ZIO[Any, Nothing, zio.aws.appstream.model.ImagePermissions.ReadOnly] =
      ZIO.succeed(imagePermissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.SharedImagePermissions
  ) extends zio.aws.appstream.model.SharedImagePermissions.ReadOnly {
    override val sharedAccountId: AwsAccountId =
      zio.aws.appstream.model.primitives.AwsAccountId(impl.sharedAccountId())
    override val imagePermissions
        : zio.aws.appstream.model.ImagePermissions.ReadOnly =
      zio.aws.appstream.model.ImagePermissions.wrap(impl.imagePermissions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.SharedImagePermissions
  ): zio.aws.appstream.model.SharedImagePermissions.ReadOnly = new Wrapper(impl)
}
