package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{
  Timestamp,
  Arn,
  RedirectURL,
  EmbedHostDomain,
  FeedbackURL
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Stack(
    arn: Optional[Arn] = Optional.Absent,
    name: String,
    description: Optional[String] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    storageConnectors: Optional[
      Iterable[zio.aws.appstream.model.StorageConnector]
    ] = Optional.Absent,
    redirectURL: Optional[RedirectURL] = Optional.Absent,
    feedbackURL: Optional[FeedbackURL] = Optional.Absent,
    stackErrors: Optional[Iterable[zio.aws.appstream.model.StackError]] =
      Optional.Absent,
    userSettings: Optional[Iterable[zio.aws.appstream.model.UserSetting]] =
      Optional.Absent,
    applicationSettings: Optional[
      zio.aws.appstream.model.ApplicationSettingsResponse
    ] = Optional.Absent,
    accessEndpoints: Optional[
      Iterable[zio.aws.appstream.model.AccessEndpoint]
    ] = Optional.Absent,
    embedHostDomains: Optional[Iterable[EmbedHostDomain]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.appstream.model.Stack = {
    import Stack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Stack
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        storageConnectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConnectors)
      .optionallyWith(
        redirectURL.map(value => RedirectURL.unwrap(value): java.lang.String)
      )(_.redirectURL)
      .optionallyWith(
        feedbackURL.map(value => FeedbackURL.unwrap(value): java.lang.String)
      )(_.feedbackURL)
      .optionallyWith(
        stackErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackErrors)
      .optionallyWith(
        userSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userSettings)
      .optionallyWith(applicationSettings.map(value => value.buildAwsValue()))(
        _.applicationSettings
      )
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .optionallyWith(
        embedHostDomains.map(value =>
          value.map { item =>
            EmbedHostDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.embedHostDomains)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Stack.ReadOnly =
    zio.aws.appstream.model.Stack.wrap(buildAwsValue())
}
object Stack {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.Stack] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Stack =
      zio.aws.appstream.model.Stack(
        arn.map(value => value),
        name,
        description.map(value => value),
        displayName.map(value => value),
        createdTime.map(value => value),
        storageConnectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        redirectURL.map(value => value),
        feedbackURL.map(value => value),
        stackErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationSettings.map(value => value.asEditable),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        embedHostDomains.map(value => value)
      )
    def arn: Optional[Arn]
    def name: String
    def description: Optional[String]
    def displayName: Optional[String]
    def createdTime: Optional[Timestamp]
    def storageConnectors
        : Optional[List[zio.aws.appstream.model.StorageConnector.ReadOnly]]
    def redirectURL: Optional[RedirectURL]
    def feedbackURL: Optional[FeedbackURL]
    def stackErrors: Optional[List[zio.aws.appstream.model.StackError.ReadOnly]]
    def userSettings
        : Optional[List[zio.aws.appstream.model.UserSetting.ReadOnly]]
    def applicationSettings
        : Optional[zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly]
    def accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def embedHostDomains: Optional[List[EmbedHostDomain]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getStorageConnectors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.StorageConnector.ReadOnly
    ]] = AwsError.unwrapOptionField("storageConnectors", storageConnectors)
    def getRedirectURL: ZIO[Any, AwsError, RedirectURL] =
      AwsError.unwrapOptionField("redirectURL", redirectURL)
    def getFeedbackURL: ZIO[Any, AwsError, FeedbackURL] =
      AwsError.unwrapOptionField("feedbackURL", feedbackURL)
    def getStackErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.StackError.ReadOnly
    ]] = AwsError.unwrapOptionField("stackErrors", stackErrors)
    def getUserSettings: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("userSettings", userSettings)
    def getApplicationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("applicationSettings", applicationSettings)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
    def getEmbedHostDomains: ZIO[Any, AwsError, List[EmbedHostDomain]] =
      AwsError.unwrapOptionField("embedHostDomains", embedHostDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Stack
  ) extends zio.aws.appstream.model.Stack.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val name: String = impl.name(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val storageConnectors
        : Optional[List[zio.aws.appstream.model.StorageConnector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageConnectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.StorageConnector.wrap(item)
          }.toList
        )
    override val redirectURL: Optional[RedirectURL] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectURL())
      .map(value => zio.aws.appstream.model.primitives.RedirectURL(value))
    override val feedbackURL: Optional[FeedbackURL] = zio.aws.core.internal
      .optionalFromNullable(impl.feedbackURL())
      .map(value => zio.aws.appstream.model.primitives.FeedbackURL(value))
    override val stackErrors
        : Optional[List[zio.aws.appstream.model.StackError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.StackError.wrap(item)
          }.toList
        )
    override val userSettings
        : Optional[List[zio.aws.appstream.model.UserSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.UserSetting.wrap(item)
          }.toList
        )
    override val applicationSettings: Optional[
      zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSettings())
      .map(value =>
        zio.aws.appstream.model.ApplicationSettingsResponse.wrap(value)
      )
    override val accessEndpoints
        : Optional[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.AccessEndpoint.wrap(item)
          }.toList
        )
    override val embedHostDomains: Optional[List[EmbedHostDomain]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.embedHostDomains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.EmbedHostDomain(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Stack
  ): zio.aws.appstream.model.Stack.ReadOnly = new Wrapper(impl)
}
