package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait StackAttribute {
  def unwrap: software.amazon.awssdk.services.appstream.model.StackAttribute
}
object StackAttribute {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.StackAttribute
  ): zio.aws.appstream.model.StackAttribute = value match {
    case software.amazon.awssdk.services.appstream.model.StackAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTORS =>
      val r = STORAGE_CONNECTORS
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTOR_HOMEFOLDERS =>
      val r = STORAGE_CONNECTOR_HOMEFOLDERS
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTOR_GOOGLE_DRIVE =>
      val r = STORAGE_CONNECTOR_GOOGLE_DRIVE
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTOR_ONE_DRIVE =>
      val r = STORAGE_CONNECTOR_ONE_DRIVE
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.REDIRECT_URL =>
      val r = REDIRECT_URL
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.FEEDBACK_URL =>
      val r = FEEDBACK_URL
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.THEME_NAME =>
      val r = THEME_NAME
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.USER_SETTINGS =>
      val r = USER_SETTINGS
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.EMBED_HOST_DOMAINS =>
      val r = EMBED_HOST_DOMAINS
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.IAM_ROLE_ARN =>
      val r = IAM_ROLE_ARN
      r
    case software.amazon.awssdk.services.appstream.model.StackAttribute.ACCESS_ENDPOINTS =>
      val r = ACCESS_ENDPOINTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object STORAGE_CONNECTORS
      extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTORS
  }
  case object STORAGE_CONNECTOR_HOMEFOLDERS
      extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTOR_HOMEFOLDERS
  }
  case object STORAGE_CONNECTOR_GOOGLE_DRIVE
      extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTOR_GOOGLE_DRIVE
  }
  case object STORAGE_CONNECTOR_ONE_DRIVE
      extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.STORAGE_CONNECTOR_ONE_DRIVE
  }
  case object REDIRECT_URL extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.REDIRECT_URL
  }
  case object FEEDBACK_URL extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.FEEDBACK_URL
  }
  case object THEME_NAME extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.THEME_NAME
  }
  case object USER_SETTINGS extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.USER_SETTINGS
  }
  case object EMBED_HOST_DOMAINS
      extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.EMBED_HOST_DOMAINS
  }
  case object IAM_ROLE_ARN extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.IAM_ROLE_ARN
  }
  case object ACCESS_ENDPOINTS extends zio.aws.appstream.model.StackAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackAttribute =
      software.amazon.awssdk.services.appstream.model.StackAttribute.ACCESS_ENDPOINTS
  }
}
