package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait StackErrorCode {
  def unwrap: software.amazon.awssdk.services.appstream.model.StackErrorCode
}
object StackErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.StackErrorCode
  ): zio.aws.appstream.model.StackErrorCode = value match {
    case software.amazon.awssdk.services.appstream.model.StackErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.StackErrorCode.STORAGE_CONNECTOR_ERROR =>
      val r = STORAGE_CONNECTOR_ERROR
      r
    case software.amazon.awssdk.services.appstream.model.StackErrorCode.INTERNAL_SERVICE_ERROR =>
      val r = INTERNAL_SERVICE_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.StackErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackErrorCode =
      software.amazon.awssdk.services.appstream.model.StackErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object STORAGE_CONNECTOR_ERROR
      extends zio.aws.appstream.model.StackErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackErrorCode =
      software.amazon.awssdk.services.appstream.model.StackErrorCode.STORAGE_CONNECTOR_ERROR
  }
  case object INTERNAL_SERVICE_ERROR
      extends zio.aws.appstream.model.StackErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.StackErrorCode =
      software.amazon.awssdk.services.appstream.model.StackErrorCode.INTERNAL_SERVICE_ERROR
  }
}
