package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{Description, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEntitlementRequest(
    name: Name,
    stackName: Name,
    description: Optional[Description] = Optional.Absent,
    appVisibility: Optional[zio.aws.appstream.model.AppVisibility] =
      Optional.Absent,
    attributes: Optional[
      Iterable[zio.aws.appstream.model.EntitlementAttribute]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest = {
    import UpdateEntitlementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .stackName(Name.unwrap(stackName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(appVisibility.map(value => value.unwrap))(_.appVisibility)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateEntitlementRequest.ReadOnly =
    zio.aws.appstream.model.UpdateEntitlementRequest.wrap(buildAwsValue())
}
object UpdateEntitlementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateEntitlementRequest =
      zio.aws.appstream.model.UpdateEntitlementRequest(
        name,
        stackName,
        description.map(value => value),
        appVisibility.map(value => value),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Name
    def stackName: Name
    def description: Optional[Description]
    def appVisibility: Optional[zio.aws.appstream.model.AppVisibility]
    def attributes
        : Optional[List[zio.aws.appstream.model.EntitlementAttribute.ReadOnly]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAppVisibility
        : ZIO[Any, AwsError, zio.aws.appstream.model.AppVisibility] =
      AwsError.unwrapOptionField("appVisibility", appVisibility)
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.EntitlementAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest
  ) extends zio.aws.appstream.model.UpdateEntitlementRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appstream.model.primitives.Description(value))
    override val appVisibility
        : Optional[zio.aws.appstream.model.AppVisibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appVisibility())
        .map(value => zio.aws.appstream.model.AppVisibility.wrap(value))
    override val attributes: Optional[
      List[zio.aws.appstream.model.EntitlementAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.EntitlementAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest
  ): zio.aws.appstream.model.UpdateEntitlementRequest.ReadOnly = new Wrapper(
    impl
  )
}
