package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{
  Timestamp,
  UserAttributeValue,
  Username,
  Arn
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class User(
    arn: Optional[Arn] = Optional.Absent,
    userName: Optional[Username] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    firstName: Optional[UserAttributeValue] = Optional.Absent,
    lastName: Optional[UserAttributeValue] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    authenticationType: zio.aws.appstream.model.AuthenticationType
) {
  def buildAwsValue(): software.amazon.awssdk.services.appstream.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.User
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        userName.map(value => Username.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        firstName.map(value =>
          UserAttributeValue.unwrap(value): java.lang.String
        )
      )(_.firstName)
      .optionallyWith(
        lastName.map(value =>
          UserAttributeValue.unwrap(value): java.lang.String
        )
      )(_.lastName)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .authenticationType(authenticationType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.User.ReadOnly =
    zio.aws.appstream.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.User = zio.aws.appstream.model.User(
      arn.map(value => value),
      userName.map(value => value),
      enabled.map(value => value),
      status.map(value => value),
      firstName.map(value => value),
      lastName.map(value => value),
      createdTime.map(value => value),
      authenticationType
    )
    def arn: Optional[Arn]
    def userName: Optional[Username]
    def enabled: Optional[Boolean]
    def status: Optional[String]
    def firstName: Optional[UserAttributeValue]
    def lastName: Optional[UserAttributeValue]
    def createdTime: Optional[Timestamp]
    def authenticationType: zio.aws.appstream.model.AuthenticationType
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getUserName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("userName", userName)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFirstName: ZIO[Any, AwsError, UserAttributeValue] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, UserAttributeValue] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appstream.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.User
  ) extends zio.aws.appstream.model.User.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val userName: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.appstream.model.primitives.Username(value))
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val firstName: Optional[UserAttributeValue] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value =>
        zio.aws.appstream.model.primitives.UserAttributeValue(value)
      )
    override val lastName: Optional[UserAttributeValue] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value =>
        zio.aws.appstream.model.primitives.UserAttributeValue(value)
      )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val authenticationType
        : zio.aws.appstream.model.AuthenticationType =
      zio.aws.appstream.model.AuthenticationType.wrap(impl.authenticationType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.User
  ): zio.aws.appstream.model.User.ReadOnly = new Wrapper(impl)
}
