package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserStackAssociationError(
    userStackAssociation: Optional[
      zio.aws.appstream.model.UserStackAssociation
    ] = Optional.Absent,
    errorCode: Optional[zio.aws.appstream.model.UserStackAssociationErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UserStackAssociationError = {
    import UserStackAssociationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UserStackAssociationError
      .builder()
      .optionallyWith(userStackAssociation.map(value => value.buildAwsValue()))(
        _.userStackAssociation
      )
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UserStackAssociationError.ReadOnly =
    zio.aws.appstream.model.UserStackAssociationError.wrap(buildAwsValue())
}
object UserStackAssociationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UserStackAssociationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UserStackAssociationError =
      zio.aws.appstream.model.UserStackAssociationError(
        userStackAssociation.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def userStackAssociation
        : Optional[zio.aws.appstream.model.UserStackAssociation.ReadOnly]
    def errorCode
        : Optional[zio.aws.appstream.model.UserStackAssociationErrorCode]
    def errorMessage: Optional[String]
    def getUserStackAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.UserStackAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("userStackAssociation", userStackAssociation)
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.UserStackAssociationErrorCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UserStackAssociationError
  ) extends zio.aws.appstream.model.UserStackAssociationError.ReadOnly {
    override val userStackAssociation
        : Optional[zio.aws.appstream.model.UserStackAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userStackAssociation())
        .map(value => zio.aws.appstream.model.UserStackAssociation.wrap(value))
    override val errorCode
        : Optional[zio.aws.appstream.model.UserStackAssociationErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value =>
          zio.aws.appstream.model.UserStackAssociationErrorCode.wrap(value)
        )
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UserStackAssociationError
  ): zio.aws.appstream.model.UserStackAssociationError.ReadOnly = new Wrapper(
    impl
  )
}
