package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait UserStackAssociationErrorCode {
  def unwrap: software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode
}
object UserStackAssociationErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode
  ): zio.aws.appstream.model.UserStackAssociationErrorCode = value match {
    case software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.STACK_NOT_FOUND =>
      val r = STACK_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.USER_NAME_NOT_FOUND =>
      val r = USER_NAME_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.DIRECTORY_NOT_FOUND =>
      val r = DIRECTORY_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.UserStackAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode =
      software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object STACK_NOT_FOUND
      extends zio.aws.appstream.model.UserStackAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode =
      software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.STACK_NOT_FOUND
  }
  case object USER_NAME_NOT_FOUND
      extends zio.aws.appstream.model.UserStackAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode =
      software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.USER_NAME_NOT_FOUND
  }
  case object DIRECTORY_NOT_FOUND
      extends zio.aws.appstream.model.UserStackAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode =
      software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.DIRECTORY_NOT_FOUND
  }
  case object INTERNAL_ERROR
      extends zio.aws.appstream.model.UserStackAssociationErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode =
      software.amazon.awssdk.services.appstream.model.UserStackAssociationErrorCode.INTERNAL_ERROR
  }
}
