package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApiCache(
    ttl: Optional[Long] = Optional.Absent,
    apiCachingBehavior: Optional[zio.aws.appsync.model.ApiCachingBehavior] =
      Optional.Absent,
    transitEncryptionEnabled: Optional[Boolean] = Optional.Absent,
    atRestEncryptionEnabled: Optional[Boolean] = Optional.Absent,
    `type`: Optional[zio.aws.appsync.model.ApiCacheType] = Optional.Absent,
    status: Optional[zio.aws.appsync.model.ApiCacheStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ApiCache = {
    import ApiCache.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ApiCache
      .builder()
      .optionallyWith(ttl.map(value => value: java.lang.Long))(_.ttl)
      .optionallyWith(apiCachingBehavior.map(value => value.unwrap))(
        _.apiCachingBehavior
      )
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ApiCache.ReadOnly =
    zio.aws.appsync.model.ApiCache.wrap(buildAwsValue())
}
object ApiCache {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.ApiCache] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ApiCache =
      zio.aws.appsync.model.ApiCache(
        ttl.map(value => value),
        apiCachingBehavior.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        `type`.map(value => value),
        status.map(value => value)
      )
    def ttl: Optional[Long]
    def apiCachingBehavior: Optional[zio.aws.appsync.model.ApiCachingBehavior]
    def transitEncryptionEnabled: Optional[Boolean]
    def atRestEncryptionEnabled: Optional[Boolean]
    def `type`: Optional[zio.aws.appsync.model.ApiCacheType]
    def status: Optional[zio.aws.appsync.model.ApiCacheStatus]
    def getTtl: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("ttl", ttl)
    def getApiCachingBehavior
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiCachingBehavior] =
      AwsError.unwrapOptionField("apiCachingBehavior", apiCachingBehavior)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("transitEncryptionEnabled", transitEncryptionEnabled)
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("atRestEncryptionEnabled", atRestEncryptionEnabled)
    def getType: ZIO[Any, AwsError, zio.aws.appsync.model.ApiCacheType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, zio.aws.appsync.model.ApiCacheStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ApiCache
  ) extends zio.aws.appsync.model.ApiCache.ReadOnly {
    override val ttl: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.ttl())
      .map(value => value: Long)
    override val apiCachingBehavior
        : Optional[zio.aws.appsync.model.ApiCachingBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCachingBehavior())
        .map(value => zio.aws.appsync.model.ApiCachingBehavior.wrap(value))
    override val transitEncryptionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitEncryptionEnabled())
        .map(value => value: Boolean)
    override val atRestEncryptionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atRestEncryptionEnabled())
        .map(value => value: Boolean)
    override val `type`: Optional[zio.aws.appsync.model.ApiCacheType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.appsync.model.ApiCacheType.wrap(value))
    override val status: Optional[zio.aws.appsync.model.ApiCacheStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.appsync.model.ApiCacheStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ApiCache
  ): zio.aws.appsync.model.ApiCache.ReadOnly = new Wrapper(impl)
}
