package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApiCacheResponse(
    apiCache: Optional[zio.aws.appsync.model.ApiCache] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse = {
    import CreateApiCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse
      .builder()
      .optionallyWith(apiCache.map(value => value.buildAwsValue()))(_.apiCache)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly =
    zio.aws.appsync.model.CreateApiCacheResponse.wrap(buildAwsValue())
}
object CreateApiCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateApiCacheResponse =
      zio.aws.appsync.model
        .CreateApiCacheResponse(apiCache.map(value => value.asEditable))
    def apiCache: Optional[zio.aws.appsync.model.ApiCache.ReadOnly]
    def getApiCache
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiCache.ReadOnly] =
      AwsError.unwrapOptionField("apiCache", apiCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse
  ) extends zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly {
    override val apiCache: Optional[zio.aws.appsync.model.ApiCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiCache())
        .map(value => zio.aws.appsync.model.ApiCache.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse
  ): zio.aws.appsync.model.CreateApiCacheResponse.ReadOnly = new Wrapper(impl)
}
