package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateTypeRequest(
    apiId: String,
    definition: String,
    format: zio.aws.appsync.model.TypeDefinitionFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateTypeRequest = {
    import CreateTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateTypeRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .definition(definition: java.lang.String)
      .format(format.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateTypeRequest.ReadOnly =
    zio.aws.appsync.model.CreateTypeRequest.wrap(buildAwsValue())
}
object CreateTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateTypeRequest =
      zio.aws.appsync.model.CreateTypeRequest(apiId, definition, format)
    def apiId: String
    def definition: String
    def format: zio.aws.appsync.model.TypeDefinitionFormat
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getDefinition: ZIO[Any, Nothing, String] = ZIO.succeed(definition)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.appsync.model.TypeDefinitionFormat] =
      ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateTypeRequest
  ) extends zio.aws.appsync.model.CreateTypeRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val definition: String = impl.definition(): String
    override val format: zio.aws.appsync.model.TypeDefinitionFormat =
      zio.aws.appsync.model.TypeDefinitionFormat.wrap(impl.format())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateTypeRequest
  ): zio.aws.appsync.model.CreateTypeRequest.ReadOnly = new Wrapper(impl)
}
