package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait DefaultAction {
  def unwrap: software.amazon.awssdk.services.appsync.model.DefaultAction
}
object DefaultAction {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.DefaultAction
  ): zio.aws.appsync.model.DefaultAction = value match {
    case software.amazon.awssdk.services.appsync.model.DefaultAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.DefaultAction.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.appsync.model.DefaultAction.DENY =>
      val r = DENY
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.DefaultAction {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DefaultAction =
      software.amazon.awssdk.services.appsync.model.DefaultAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.appsync.model.DefaultAction {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DefaultAction =
      software.amazon.awssdk.services.appsync.model.DefaultAction.ALLOW
  }
  case object DENY extends zio.aws.appsync.model.DefaultAction {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DefaultAction =
      software.amazon.awssdk.services.appsync.model.DefaultAction.DENY
  }
}
