package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDomainNameRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest = {
    import DeleteDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteDomainNameRequest.ReadOnly =
    zio.aws.appsync.model.DeleteDomainNameRequest.wrap(buildAwsValue())
}
object DeleteDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteDomainNameRequest =
      zio.aws.appsync.model.DeleteDomainNameRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest
  ) extends zio.aws.appsync.model.DeleteDomainNameRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appsync.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest
  ): zio.aws.appsync.model.DeleteDomainNameRequest.ReadOnly = new Wrapper(impl)
}
